#ifndef __Toggle_Taster__
#define __Toggle_Taster__

#include <Arduino.h>

/*
 *  Anleitung: Um diese Klasse benutzen zu können muss in der .ino als erstes der Konstruktor aufgerufen werden - mit dem Input und Output-Pin (Pinnummer)
 *  z.B. ToggleHardwarepin var_name(InputPin,OutputPin);
 *  im Loop muss dann dementsprechend var_name.toggle() eingetragen werden, damit aktiv der Inputpin abgefragt wird.
 * 
 *  ToDos: Output-Pins nicht einfach HIGH-LOW - sondern passend AnalogWrite für DIMM-Funktion z.B.
 * 
 *	Hosted by Schlumpfontour.de, zur freien Verwendung! Bitte diese Werbung drin lassen. Neue Versionen gibt es bei Update hier: http://www.schlumpfontour.de/smartcamper-esp32-ein-paar-selbstgeschrieben-klassen_3267
 *
 *
 */

class ToggleHardwarepin {
private:
	int button_state = LOW;
	int button_state_old = LOW;
	int output_state = LOW;
	int output_state_intensity = 255;
	int toggle_timer = 0;
	int bounce_wait = 200;
	int input_pin;										//Hardwarepin für Input (Taster)
	int output_pin;										//Hardwarepin für Output (LED)
public:
	ToggleHardwarepin(int input_pin, int output_pin);	// Constructor für Klasse
	void toggle();
  void webtoggle();
	int outstate();

};


#endif
