#include "toggle.h"

ToggleHardwarepin::ToggleHardwarepin(int input_pin, int output_pin) {
	this->input_pin = input_pin;
	this->output_pin = output_pin;
}

int ToggleHardwarepin::outstate(){
	return this->output_state;
}

void ToggleHardwarepin::webtoggle() {
   pinMode(output_pin, OUTPUT);
  // Read the state of the pushbutton value:
  button_state = 1;
  // Check if the input just went from LOW and HIGH (button release).  
  // Also check if this LOW-to-HIGH transition hasn't ocurred in the
  // past 200ms
  if ((button_state == HIGH) &&
  (button_state_old == LOW) &&
  ((millis() - toggle_timer) > bounce_wait)) {
    if (output_state == HIGH) {
      output_state = LOW;
    }
    else {
      output_state = HIGH;
    }
    toggle_timer = millis();
  }
  button_state_old = button_state;
  digitalWrite(output_pin, output_state);
}

void ToggleHardwarepin::toggle(){
   pinMode(input_pin, INPUT_PULLUP);
   pinMode(output_pin, OUTPUT);
	// Read the state of the pushbutton value:
	button_state = digitalRead(input_pin);
	// Check if the input just went from LOW and HIGH (button release).  
	// Also check if this LOW-to-HIGH transition hasn't ocurred in the
	// past 200ms
	if ((button_state == HIGH) &&
	(button_state_old == LOW) &&
	((millis() - toggle_timer) > bounce_wait)) {
		if (output_state == HIGH) {
			output_state = LOW;
		}
		else {
			output_state = HIGH;
		}
		toggle_timer = millis();
	}
	button_state_old = button_state;
  digitalWrite(output_pin, output_state);
  
}

